<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Sight Visibility Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis kontroly terénu</title>
            </head>
            <body>
				<xsl:for-each select="InRoads">
					<center>
						<!-- Report Title -->
						<h1 lang="en">Výpis kontroly terénu</h1>
						<p lang="en">
							Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
							Čas:&#xa0; <xsl:value-of select="cif:time()"/>
						</p>
					</center>
					<!-- Sight Visibility Section Data -->
					<xsl:for-each select="TerrainCheckElement">
						<!-- Sight Line Information -->
						<h2 lang="en" align="left" style="color:black;font-size:14px">
							Název prvku: <xsl:value-of select="@ElementName"/>
							&#160;&#160;&#160;&#160;Typ prvku: <xsl:value-of select="@ElementType"/>
							&#160;&#160;&#160;&#160;Tolerance: <xsl:value-of select="cif:distanceFormat(number(//InRoads/TerrainSummaryDataElement/@Tolerance))"/>
						</h2>
						<table class="margin" width="50%">
							<thead style="display:table-header-group" cellpadding="15">
								<tr>
									<th class="underline" align="center" lang="en">X</th>
									<th class="underline" align="center" lang="en">Y</th>
									<th class="underline" align="center" lang="en">Délka</th>
									<th class="underline" align="center" lang="en">Kontrolovaná výška</th>
									<th class="underline" align="center" lang="en">Výška terénu</th>
									<th class="underline" align="center" lang="en">Rozdíl Z</th>
									<th class="underline" align="center" lang="en">Tolerance</th>
								</tr>
							</thead>
							<xsl:for-each select="TerrainDataElement">
								<tbody>
									<tr>
										<td class="sidepad" align="center" nowrap="nowrap" style="color:black;">
											<xsl:value-of select="cif:distanceFormat(number(@xCoordinate))"/>
										</td>
										<td class="sidepad" align="center" nowrap="nowrap" style="color:black;">
											<xsl:value-of select="cif:distanceFormat(number(@yCoordinate))"/>
										</td>
										<td class="sidepad" align="center" nowrap="nowrap" style="color:black;">
											<xsl:value-of select="cif:distanceFormat(number(@Length))"/>
										</td>
										<td class="sidepad" align="center" nowrap="nowrap" style="color:black;">
											<xsl:value-of select="cif:distanceFormat(number(@CheckElevation))"/>
										</td>
										<xsl:choose>
											<xsl:when test="@TerrainElevation = 'External'">
												<td class="sidepad" align="center" nowrap="nowrap" style="color:red;">
													<xsl:value-of select="@TerrainElevation"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="sidepad" align="center" nowrap="nowrap" style="color:black;">
													<xsl:value-of select="cif:distanceFormat(number(@TerrainElevation))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
										<td class="sidepad" align="center" nowrap="nowrap" style="color:black;">
											<xsl:value-of select="cif:distanceFormat(number(@ElevationDifference))"/>
										</td>
										<xsl:choose>
											<xsl:when test="@ElevationDifference = 0">
												<td class="sidepad" align="center" nowrap="nowrap" style="color:#00dd00;" lang="en">V rozsahu</td>
											</xsl:when>
											<xsl:when test="number(format-number(@ElevationDifference, '#.#########;#.#########')) &lt; //InRoads/TerrainSummaryDataElement/@Tolerance">
												<td class="sidepad" align="center" nowrap="nowrap" style="color:#00dd00;" lang="en">V rozsahu</td>
											</xsl:when>
											<xsl:when test="@ElevationDifference = ''">
												<td class="sidepad" align="center" nowrap="nowrap" style="color:black;" lang="en">N/A</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="sidepad" align="center" nowrap="nowrap" style="color:red;" lang="en">Mimo</td>
											</xsl:otherwise>
										</xsl:choose>
									</tr>
								</tbody>
							</xsl:for-each>
						</table>
					</xsl:for-each>
					<xsl:for-each select="TerrainSummaryDataElement">
						<p lang="en">
							<br/><font size="+1">Souhrn:</font><br/><br/>
							Tolerance:&#xa0; <xsl:value-of select="cif:distanceFormat(number(@Tolerance))"/><br/>
							Počet bodů:&#xa0; <xsl:value-of select="@numPoints"/><br/>
							Počet bodů nad terénem:&#xa0; <xsl:value-of select="@pointsAbove"/><br/>
							Počet bodů pod terénem:&#xa0; <xsl:value-of select="@pointsBelow"/><br/>
							Počet bodů uvnitř tolerance terénu:&#xa0; <xsl:value-of select="@pointsEqual"/><br/>
							Počet bodů mimo terén:&#xa0; <xsl:value-of select="@pointsExtern"/><br/>
							<xsl:value-of select="cif:distanceFormat(number(@maxAbove))"/> je maximální rozdíl nad&#xa0; <br/>
							<xsl:value-of select="cif:distanceFormat(number(@maxBelow))"/> je maximální rozdíl pod&#xa0; 
						</p>
					</xsl:for-each>
				</xsl:for-each>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
